/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.util.LogoXMLHandler;
import DE.siemens.ad.logo.util.Version;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogoModemSetting
extends LogoXMLHandler {
    private static LogoModemSetting singletonInstance;

    public static LogoModemSetting getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new LogoModemSetting();
        }
        singletonInstance.refrehDocument();
        return singletonInstance;
    }

    private LogoModemSetting() {
    }

    public List<String> getModemType(boolean local) {
        ArrayList<String> modemType = new ArrayList<String>();
        List modemList = new ArrayList();
        modemList = local ? this.fDocument.selectNodes("//Modem/LocalModem") : this.fDocument.selectNodes("//Modem/RemoteModem");
        for (Element node : modemList) {
            String name = node.valueOf("@name");
            if (name.equals("")) continue;
            modemType.add(name);
        }
        return modemType;
    }

    @Override
    protected Document createDocument() {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("LOGO");
        Element node = root.addElement("Modem");
        node.addAttribute("DefaultLocal", "").addAttribute("DefaultRemote", "");
        this.writeXML(document);
        return document;
    }

    @Override
    protected String getPath() {
        Version v = Version.getCurrentVersion();
        return System.getProperty("user.home", "") + "/." + v.getApplicationFileName() + v.getMajorVersion() + "." + v.getMinorVersion() + "/" + "ModemSetting.xml";
    }

    public boolean deleteModem(boolean local, String modemName) {
        try {
            List modemList = new ArrayList();
            modemList = local ? this.fDocument.selectNodes("//Modem/LocalModem") : this.fDocument.selectNodes("//Modem/RemoteModem");
            for (Element node : modemList) {
                String name = node.valueOf("@name");
                if (!name.equals(modemName)) continue;
                node.getParent().remove(node);
                modemList.remove(node);
                break;
            }
            Element modemRoot = (Element)this.fDocument.selectSingleNode("//Modem");
            String nextModem = "";
            if (local) {
                if (modemRoot.valueOf("@DefaultLocal").equals(modemName)) {
                    Iterator i = modemList.iterator();
                    if (i.hasNext()) {
                        nextModem = ((Element)i.next()).valueOf("@name");
                    }
                    modemRoot.addAttribute("DefaultLocal", nextModem);
                }
            } else if (modemRoot.valueOf("@DefaultRemote").equals(modemName)) {
                Iterator i = modemList.iterator();
                if (i.hasNext()) {
                    nextModem = ((Element)i.next()).valueOf("@name");
                }
                modemRoot.addAttribute("DefaultRemote", nextModem);
            }
            this.writeXML(this.fDocument);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean checkModemName(boolean local, String modemName) {
        List modemList = new ArrayList();
        modemList = local ? this.fDocument.selectNodes("//Modem/LocalModem") : this.fDocument.selectNodes("//Modem/RemoteModem");
        for (Element node : modemList) {
            String name = node.valueOf("@name");
            if (!name.equals(modemName)) continue;
            return false;
        }
        return true;
    }

    public boolean addNewModem(boolean local, String modemName, Hashtable atSetting) {
        if (!this.checkModemName(local, modemName)) {
            return false;
        }
        try {
            Element modemRoot = null;
            modemRoot = local ? ((Element)this.fDocument.selectSingleNode("//Modem")).addElement("LocalModem").addAttribute("name", modemName) : ((Element)this.fDocument.selectSingleNode("//Modem")).addElement("RemoteModem").addAttribute("name", modemName);
            Enumeration atSettingEnum = atSetting.keys();
            while (atSettingEnum.hasMoreElements()) {
                String key = (String)atSettingEnum.nextElement();
                modemRoot.addElement(key).addText(atSetting.get(key).toString());
            }
            this.setDefaultModem(local, modemName);
            this.writeXML(this.fDocument);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean modifyModemSetting(boolean local, String modemName, Hashtable atSetting) {
        try {
            List modemList = new ArrayList();
            modemList = local ? this.fDocument.selectNodes("//Modem/LocalModem") : this.fDocument.selectNodes("//Modem/RemoteModem");
            for (Element node : modemList) {
                String name = node.valueOf("@name");
                if (!name.equals(modemName)) continue;
                Iterator childNodes = node.elementIterator();
                while (childNodes.hasNext()) {
                    Element child = (Element)childNodes.next();
                    child.setText(atSetting.get(child.getName()).toString());
                }
                break block2;
            }
            this.setDefaultModem(local, modemName);
            this.writeXML(this.fDocument);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Hashtable getAtSetting(boolean local, String modemName) {
        Hashtable<String, String> atSetting = new Hashtable<String, String>();
        List modemList = new ArrayList();
        modemList = local ? this.fDocument.selectNodes("//Modem/LocalModem") : this.fDocument.selectNodes("//Modem/RemoteModem");
        for (Element node : modemList) {
            String name = node.valueOf("@name");
            if (!name.equals(modemName)) continue;
            Iterator childernNodes = node.elementIterator();
            while (childernNodes.hasNext()) {
                Element child = (Element)childernNodes.next();
                atSetting.put(child.getName(), child.getTextTrim());
            }
            break block0;
        }
        return atSetting;
    }

    public Hashtable getDefaultSettingName() {
        Hashtable<String, String> defalutSetting = new Hashtable<String, String>();
        Element modemRoot = (Element)this.fDocument.selectSingleNode("//Modem");
        defalutSetting.put("DefaultLocal", modemRoot.valueOf("@DefaultLocal"));
        defalutSetting.put("DefaultRemote", modemRoot.valueOf("@DefaultRemote"));
        return defalutSetting;
    }

    private void setDefaultModem(boolean local, String name) {
        Element modemRoot = (Element)this.fDocument.selectSingleNode("//Modem");
        if (local) {
            modemRoot.addAttribute("DefaultLocal", name);
        } else {
            modemRoot.addAttribute("DefaultRemote", name);
        }
    }

    @Override
    protected Document readXML() {
        SAXReader reader = new SAXReader();
        this.fDocument = DocumentHelper.createDocument();
        try {
            this.fDocument = reader.read(this.getPath());
        }
        catch (Exception e) {
            try {
                this.fDocument = reader.read("file:///" + this.getPath());
            }
            catch (Exception ex) {
                this.fDocument = this.createDocument();
            }
        }
        return this.fDocument;
    }
}

